/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: UMath.h,v 1.2 1999/09/17 04:20:46 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_UMath_h	// [
#define Included_UMath_h

#include "pgpClassesConfig.h"

_PGP_BEGIN

namespace UMath
{
	template <typename T> 
	inline 
	T 
	CeilDiv(T a, T b)
	{
		if (a % b)
			return ((a / b) + 1);
		else
			return (a / b);
	}

	template <typename T> 
	inline 
	T 
	RoundUpToMultiple(T a, T b)
	{
		if (a % b)
			return (a + (b - a%b));
		else
			return a;
	}

	inline 
	PGPUInt8 
	GetHighByte(PGPUInt16 w)
	{
		return static_cast<PGPUInt8>((w & 0xFF00) >> 8);
	}

	inline 
	PGPUInt8 
	GetLowByte(PGPUInt16 w)
	{
		return static_cast<PGPUInt8>(w & 0x00FF);
	}

	inline 
	PGPUInt16 
	GetHighWord(PGPUInt32 dw)
	{
		return static_cast<PGPUInt16>((dw & 0xFFFF0000) >> 16);
	}

	inline 
	PGPUInt16 
	GetLowWord(PGPUInt32 dw)
	{
		return static_cast<PGPUInt16>(dw & 0x0000FFFF);
	}

	inline 
	PGPUInt32 
	GetHighDWord(PGPUInt64 qw)
	{
		return static_cast<PGPUInt32>((qw & 0xFFFFFFFF00000000) >> 32);
	}

	inline 
	PGPUInt32 
	GetLowDWord(PGPUInt64 qw)
	{
		return static_cast<PGPUInt32>(qw & 0x00000000FFFFFFFF);
	}

	inline 
	PGPUInt16 
	MakeWord(PGPUInt8 low, PGPUInt8 high)
	{
		return ((static_cast<PGPUInt16>(high) << 8) | low);
	}

	inline 
	PGPUInt32 
	MakeDWord(PGPUInt16 low, PGPUInt16 high)
	{
		return ((static_cast<PGPUInt32>(high) << 16) | low);
	}

	inline 
	PGPUInt64 
	MakeQWord(PGPUInt32 low, PGPUInt32 high)
	{
		return ((static_cast<PGPUInt64>(high) << 32) | low);
	}

	inline 
	PGPBoolean 
	IsValidHexChar(char c)
	{
		c = static_cast<char>(toupper(c));

		return (((c >= '0') && (c <= '9')) || ((c >= 'A') && (c <= 'F')));
	}

	inline 
	PGPUInt8 
	SimpleLog2(PGPUInt32 a)
	{
		PGPUInt8	i	= 0;

		while (a > 1)
		{
			a = a >> 1;
			i++;
		}

		return i;
	}
}

_PGP_END

#endif	// Included_UMath_h
